/* 
 * File:   SelectObject.h
 * Author: Marcel Duris
 *
 * Created on March 11, 2012, 9:54 AM
 * 
 * Jednoduchy wrapper pre rozne akcie vykonavane pouzivatelom.
 */

#include <cstdlib>
#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>
#include "SelectAction.h"

using namespace cv;
using namespace std;

#ifndef SELECTOBJECT_H
#define	SELECTOBJECT_H

class SelectObject {
public:
    SelectObject(string wname, SelectAction *action);
    SelectObject(const SelectObject& orig);
    virtual ~SelectObject();
    
    void getUserInput(Mat &dst);
    void showWindow();
    
    bool continueSelecting();
    
    SelectAction *action;
private:
    Mat orig, show, edges;
    string wname;
    bool contsel;
    
};

#endif	/* SELECTOBJECT_H */

