/* 
 * File:   tests.cpp
 * Author: Marcel Duris
 *
 * Created on March 16, 2012, 10:47 PM
 */

#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

#include <iostream>
#include <cstdio>
#include <fstream>
#include <sys/types.h>
#include <dirent.h>
#include <string>
#include "utils.h"
#include "tests.h"
#include "fourier.h"

using namespace cv;
using namespace std;

void testGridResponse(string descFile, const char *inPath, int count, const char * outPath) {
    
    vector<maskRegion> desc;
    vector< vector< float> > resp;
    loadMaskDesc(descFile, desc);
    char input[250];
    
    for (int i = 0; i < desc.size(); i++) {
        vector< float > response;
        resp.push_back(response);
    }
        
    for (int i = 0; i <= count; i++) {
        
        sprintf(input, inPath, i);
        Mat imgs = imread(input, CV_LOAD_IMAGE_COLOR);
                
        if (imgs.empty()) {
            continue;
        }
        
        vector<maskRegion>::iterator it = desc.begin(), it_end = desc.end();
        vector< vector< float> >::iterator resp_it = resp.begin(), resp_it_end = resp.end();
        for (int i = 0; it != it_end; ++it, ++resp_it) {
            float response = gridResponse(imgs((*it).roi), (*it).mask);
            (*resp_it).push_back(response);
        }
    }
    
    char outFile[256];
    vector< vector< float> >::iterator resp_it = resp.begin(), resp_it_end = resp.end();
    for (int mask = 0; resp_it != resp_it_end; ++resp_it, mask++) {
        
        sprintf(outFile, outPath, mask);
        ofstream out;
        out.open(outFile);
        vector< float>::iterator it = (*resp_it).begin(), it_end = (*resp_it).end();
        for (int i = 0; it != it_end; ++it, i++) {
            out << i << " " << (float)(*it) << endl;
        }
        out.close();
    }
}

void testEdgeResponse(string descFile, const char *inPath, int count, const char * outPath) {
    
    vector<maskRegion> desc;
    loadMaskDesc(descFile, desc);
    vector<maskRegion>::iterator it = desc.begin(), it_end = desc.end();
    
    char outFile[256];
    for (int i = 0; it != it_end; ++it, i++) {
        Mat mask = (*it).mask;
        Rect roi = (*it).roi;
        sprintf(outFile, outPath, i);
        testEdgeResponse(mask, roi, inPath, count, outFile);
    }
}

int maskcount = 0;

void testEdgeResponse(Mat mask, Rect roi, const char* inPath, int count, const char* outFile) {
    
    ofstream out;
    out.open(outFile);
    
    char input[250];
    
    for (int i = 0; i <= count; i++) {

        sprintf(input, inPath, i);
        Mat imgs = imread( input );
        
        if ( imgs.empty() ) {
            continue;
        }
                
        out << i << " " << edgeResponse( imgs(roi), mask);
        out << "\n";
        

    }
    maskcount++;
    out.close();
}
