/* 
 * File:   tests.h
 * Author: Marcel Duris
 *
 * Created on March 16, 2012, 10:47 PM
 * 
 * Niekolko testovacich metod pouzivanych pocas vyvoja.
 */

#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

#include <iostream>
#include <sys/types.h>
#include <dirent.h>
#include <string>

#include "utils.h"

using namespace cv;

#ifndef TESTS_H
#define	TESTS_H

/**
 * Nacita yml-ko s popismi a maskami, spusti testovanie miery dva.
 * 
 * @param descFile cesta k suboru s popismi, subory s maskami musia byt v tom istom priecinku
 * @param inPath maska k vstupom
 * @param count pocet vstupov
 * @param outFile cesta k vystupnemu suboru
 */
void testEdgeResponse(string descFile, const char *inPath, int count, const char * outPath);

/**
 * otestujre rozdiel medzi maskou a vstupmi spracovanymi mierou edge.
 * 
 * @param mask
 * @param kernel
 * @param count
 * @param inPath
 * @param outFile
 */
void testEdgeResponse(Mat mask, Rect roi, const char* inPath, int count, const char* outFile);

/**
 * Nacita yml-ko s popismi a maskami, spusti testovanie miery grid.
 * 
 * @param descFile cesta k suboru s popismi, subory s maskami musia byt v tom istom priecinku
 * @param inPath maska k vstupom
 * @param count pocet vstupov
 * @param outFile cesta k vystupnemu suboru
 */
void testGridResponse(string descFile, const char *inPath, int count, const char * outFile);

#endif	/* TESTS_H */

