/*  aarray.h
 * 
 *  R3lib
 * 
 *  Simple augmentable arrays for UINT and t_pair
 *  augmentation is done by realloc
 * 
 *  Copyright (C) 2006-2007  Michal Linhard <michal@linhard.sk>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 */
#include "aarray.h"
 
int aar_init(t_aarray* a, UINT init_size, UINT inc_size)
{
	if( !a ||
		!init_size ||
		!inc_size )
		return ERROR_BADARG;
	a->array = (UINT*) malloc(init_size*sizeof(UINT));
	if(!(a->array))
		return ERROR_MEM;
	a->alloc = init_size;
	a->inc = inc_size;
	a->size = 0;
	return 0;
}

int aar_append(t_aarray* a, UINT val)
{
	a->array[a->size] = val;
	(a->size)++;
	if(a->size == a->alloc)
	{
		a->array = (UINT*) realloc(a->array, (a->size + a->inc)*sizeof(UINT));
		if(!(a->array))
			return ERROR_MEM;
		(a->alloc)+=a->inc;
	}
	return 0;
}

int aar_compact(t_aarray* a)
{
	if(a->alloc > a->size)
	{
		a->array = (UINT*) realloc(a->array, (a->size)*sizeof(UINT));
		if(!(a->array))
			return ERROR_MEM;
		a->alloc = a->size;
	}
	return 0;
}

int aarp_init(t_aarp* a, UINT init_size, UINT inc_size)
{
	if( !a ||
		!init_size ||
		!inc_size )
		return ERROR_BADARG;
	a->array = (t_pair*) malloc(init_size*sizeof(t_pair));
	if(!(a->array))
		return ERROR_MEM;
	a->alloc = init_size;
	a->inc = inc_size;
	a->size = 0;
	return 0;
}

int aarp_append(t_aarp* a, UINT val1, UINT val2)
{
	a->array[a->size].val1 = val1;
	a->array[a->size].val2 = val2;
	(a->size)++;
	if(a->size == a->alloc)
	{
		a->array = (t_pair*) realloc(a->array, (a->size + a->inc)*sizeof(t_pair));
		if(!(a->array))
			return ERROR_MEM;
		(a->alloc)+=a->inc;
	}
	return 0;
}

int aarp_compact(t_aarp* a)
{
	if(a->alloc > a->size)
	{
		a->array = (t_pair*) realloc(a->array, (a->size)*sizeof(t_pair));
		if(!(a->array))
			return ERROR_MEM;
		a->alloc = a->size;
	}
	return 0;
}
