/*  aarray.h
 * 
 *  R3lib
 * 
 *  Simple augmentable arrays for UINT and t_pair
 *  augmentation is done by realloc
 * 
 *  Copyright (C) 2006-2007  Michal Linhard <michal@linhard.sk>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 */
#ifndef AARRAY_H
#define AARRAY_H
#include "conf.h"

#define AAR_SMALL_ALLOC 256
#define AAR_MED_ALLOC 1024
#define AAR_BIG_ALLOC 10240

/* Augmentable Array for UINT */
typedef struct s_aarray
{
	UINT* array;
	UINT  alloc;
	UINT  size;
	UINT  inc;
}
t_aarray;

/* Augmentable Array for t_pair */
typedef struct s_aarp
{
	t_pair* array;
	UINT  alloc;
	UINT  size;
	UINT  inc;
}
t_aarp;

int aar_init(t_aarray* a, UINT init_size, UINT inc_size);
int aar_append(t_aarray* a, UINT val);
int aar_compact(t_aarray* a);

int aarp_init(t_aarp* a, UINT init_size, UINT inc_size);
int aarp_append(t_aarp* a, UINT val1, UINT val2);
int aarp_compact(t_aarp* a);


	



#endif /*AARRAY_H*/
