/*  bitstr.h
 * 
 *  R3lib
 * 
 *  Bit string utils
 * 
 *  Copyright (C) 2006-2007  Michal Linhard <michal@linhard.sk>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 */
#ifndef BITSTR_H
#define BITSTR_H

#include "conf.h"

/* bitstring structure */
typedef struct s_bitstr {
  BYTE* myBooleanString; /* memory location */
  int myStringLength;    /* length of string */
  int numChar;           /* how many bytes does it occupy in memory */
} t_bitstr;

#ifdef __cplusplus
extern "C" {
#endif

/* bitstring manipulation routines */
void bs_init(t_bitstr* s, BYTE* mem, int strLength);

inline int bs_getVal(t_bitstr* s, int index);
inline void bs_setVal(t_bitstr* s, int index, int indexVal);
inline void bs_setIntv(t_bitstr* s, int start, int end, int indexVal);
inline void bs_setAll(t_bitstr* s, int val); 
inline int bs_isAllTrue(t_bitstr* s); 


#ifdef __cplusplus
} /* closing brace for extern "C" */
#endif

#endif /* BITSTR_H */
