/*  conf.h
 * 
 *  R3lib
 * 
 *  Global configuration file
 * 
 *  Copyright (C) 2006-2007  Michal Linhard <michal@linhard.sk>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 */
#ifndef CONF_H_
#define CONF_H_

#define INT_SIZE 32
#define MAX_INT_INDEX 31
#define SIGMA_SIZE ((UINT) 256)
#define MAX_CHAR_VAL 255

#define LC_CENT ((UINT) 0x00000100 )

#define REALLOC_SMALL_SEG 256

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned int UINT;

typedef struct s_pair
{
	UINT val1;
	UINT val2;
}
t_pair;

/* about FLAGUINT numbers
 * range: 0x00000000 - 0x3ffffffe, 0x3fffffff is reserved value - UNDEF
 */
#define FLAGUINT_MAX ((int) 0x3FFFFFFE)
#define UNDEF ((int) 0x3FFFFFFF)

/* unsinged int with two one-bit flags */
typedef struct sFLAGUINT {
	UINT	value : 30;
	UINT    flag1 : 1;
	UINT	flag2 : 1;
} FLAGUINT;

#define ERROR_MEM			-1		// malloc or realloc failed
#define ERROR_BADARG		-2		// bad arguments
#define ERROR_LIMIT			-3		// memory limit exceeded
#define ERROR_INTEGRITY		-4		// integrity error, assumption failed
#define ERROR_FILEOPEN		-5		// error opening file
#define ERROR_FILEREAD		-6		// error reading from file
#define ERROR_FILEWRITE		-7		// error writing to file
#define ERROR_TEST			-8		// test failed
#define ERROR_OTHER			-100	// other error

#define YES 1
#define NO  0

#undef  DEBUG1 // debug output files, only for small files
#undef  DEBUG2 // debug code working with memory only, applicable to big data too
#undef  DEBUG3 // debug output files, debugger triggered
#undef  DEBUG4 // debug output files for traverseBottomUp
#undef  DEBUG5 // testing code
#undef  DEBUG_PRINTPHASE

// this is the main place to link malloc debugging library

// original malloc
#include <malloc.h> 

// debug malloc
//#define MALLOC_DEBUG
//#define RM_TEST_DEPTH 2
//#define ELOQUENT
//#include "test/rmalloc.h"


#endif /*CONF_H_*/
