/*  analysis.h
 * 
 *  R3lib
 * 
 *  Memory utilisation analysis and statistics
 *
 *  Copyright (C) 2006-2007  Michal Linhard <michal@linhard.sk>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *  
 */
#ifndef ANALYSIS_H_
#define ANALYSIS_H_
#include <sys/time.h>
#include <stdio.h>

/* timing routines */
int time_get(struct timeval* time);
UINT time_to_ms(struct timeval* time);
void time_fprint(FILE* log, struct timeval* time); 

/* measurement for one r3 tree
 * */
typedef struct s_measurement
{
	struct timeval time; // time taken to construct r3 tree
	int n; // size of data r3 tree is constructed on
	UINT peakmem; // peak memory usage during construction of r3 tree in bytes
	UINT totalmem; // memory requirements of r3 tree in bytes
} t_measurement;

int statistics_from_files(FILE* log, char** filenames, int cnt, char* result_filename);
int statistics_from_file(char* filename, t_measurement* msr);
int statistics_complete_from_file(char* filename, char* result_filename, int minlength);

#endif /*ANALYSIS_H_*/
