/*  debug.h
 * 
 *  R3lib
 * 
 *  Debug routines
 * 
 *  Copyright (C) 2006-2007  Michal Linhard <michal@linhard.sk>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 */
#ifndef DEBUG_H_
#define DEBUG_H_

#include "../conf.h"
#include "../bitstr.h"
#include "../r3.h"

#ifdef __cplusplus
extern "C" {
#endif

void test_writability(BYTE* mem, UINT count);

int output_r3t_html_file(t_r3t* r3t, char* output_filename);
int output_r3t_html_file_file(char* input_filename, char* output_filename);

void output_union_trees(t_r3t* r3t, t_r3t_work* r3tw, char* filename);
void output_union_trees_html(t_r3t* r3t, char* filename);
void output_work_ut_info(t_r3t_work* r3tw, char* filename);
void output_sa_to_file(BYTE* text, UINT textLen, UINT* suffixArray, char* filename);
void output_sa_to_file2(BYTE* text, UINT textLen, UINT arrayLen, UINT* suffixArray, char* filename);
void output_sa_to_file3(int* text, int textLen, int* suffixArray, char* filename);
void output_sa_to_file10(BYTE* text, UINT textLen, UINT* suffixArray, char* filename);
void output_sort_suffix_state(BYTE* text, UINT textLen, UINT arrayLen, UINT* suffixArray, int* skipVal, 
                        t_bitstr* suffixType, t_bitstr* BuckA, char* filename);
void output_intarray(int* array, int arrayLen, char* filename);
void output_FLAGUINTarray(FLAGUINT* array, int arrayLen, char* filename);
void output_lists(int* list, int* boolBuckList, int buckListSize, char* filename);
void output_dist(int* dist, int distSize, int* distCnt, int maxDist, char* filename);
void output_array_buck(int* list, int listSize, int* boolBuckets, char* filename);
void output_data(BYTE* text, int textLen, int* suffixArray, char* filename);
void output_data2(BYTE* text, int n, int textLen, int* suffixArray, int* lcp, char* filename);

void output_sa_lcp_from_file(char* input_file, char* output_file);
void output_sa_lcp_from_file_trunc(char* input_file, char* output_file, int n);

void output_sa_lcp(BYTE* text, int textLen, int* suffixArray, int* lcp, char* filename);
void output_sa_lcp_trunc(BYTE* text, int textLen, int* suffixArray, int* lcp, int n, char* filename);

#ifdef __cplusplus
} /* closing brace for extern "C" */
#endif

#endif /*DEBUG_H_*/
