/*  test.h
 * 
 *  R3lib
 * 
 *  Testing routines
 *
 *  Copyright (C) 2006-2007  Michal Linhard <michal@linhard.sk>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *  
 */
#ifndef TEST_H_
#define TEST_H_
#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <sys/time.h>
#include "../conf.h"
#include "../bitstr.h"
#include "../r3.h"


#define MAXMEM 800*1024*1024 // 800MB memory limit
#define TESTN 100
#define LOGNAME "log.txt"

int test(); // main testing routine
int statistics(); // main statistics routine
int test_sa_file(FILE* log, char* filename);
int test_lcp_file(FILE* log, char* filename);
void test_realloc(FILE* log);
int load_data(BYTE** text, UINT* textLen, char* filename);
int load_repeats(t_repeat** repeats, int* cnt, char* filename);




#ifdef __cplusplus
} /* closing brace for extern "C" */
#endif

#endif /*TEST_H_*/
