/*  test_r3.h
 * 
 *  R3lib
 * 
 *  Testing routines for R3 structure 
 *
 *  Copyright (C) 2006-2007  Michal Linhard <michal@linhard.sk>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *  
 */
#ifndef TEST_R3_H
#define TEST_R3_H

#include <stdio.h> // FILE*
#include "../conf.h"
#include "../r3.h"

int test_maximal_repeat(FILE* log, BYTE* text, int textLen, int l, int p1, int p2);
int testr3t_contains_repeat(FILE* log, t_r3t* r3t, int p1, int p2, int l, int* store_p2, int* store_l);
int testr3t_contains_repeats(FILE* log, t_r3t* r3t, t_repeat* repeats, int cnt);

int testr3t_file(FILE* log, char* filename);
int testr3t_files(FILE* log, char** filenames, int cnt);
int testr3t_test1(FILE* log, t_r3t* r3t);
int testr3t_test2(FILE* log, t_r3t* r3t);
int testr3t_combine(FILE* log, t_r3t *r3t, int u, int pos, int len);
int testr3t_test_ut(FILE* log, FLAGUINT* uf, int u, BYTE* text, int textLen);


#endif /*TEST_R3_H*/
