Implementovali sme nasledovné časti spomenuté v práci:
*  Analýzu pomocou nových stavov MCV
*  Analýzu pomocou zámeny prvých kôl
*  Extrakciu MCV

Pri implementácii sa snažíme držať konvencií Solvatore.
##Indexovanie
V našej práci je iné indexovanie ako Solvatore a Jupyter-notebook
* V diplomovej práci sú uvádzané premenné x_1, x_2, ... -- indexované od 1 a MSB
* V experimentálnom prostredí v jupyter-notebook sú premenné indexované od 0, nazývame ich c_0, c_1, ... a sú MSB
* Solvatore používa LSB a indexuje od 0

Teda nech máme pomocou jupyter-notebooku nájdený rozlišovač  
[{'blue1': set([c2]), 'blue0': (c0,), 'active': (c1, c3), 'balanced': [1]}]  
Toto je ekvivalentné rozlišovaču nájdenému Solvatore  
[{'blue1': [1], 'blue0': [3], 'active': [0, 2], 'balanced': [2]}]  
 indexy balansovaných bitov aj modrých a aktívnych sú naopak. V práci by sme takýto rozlišovač uviedli takto  
 I = (A, C_0, C_1, B) = ({2,4}, {1}, {3}, {2})
 -- rovnako ako jupyter, iba +1 pre všetky premenné
 
### Analýza pomocou nových stavov MCV
Spustením modulu `analysis_blue1` je možné vykonať takúto analýzu. Úpravou trojice riadkov 
```
cipher = speck_with_key.generate_speck_version(16, 7, 2)
rounds = 6
statesize = 32
``` 
sa dá zmeniť skúmaná šifra, jej parametre a počet kôl šifry, na ktoré sa útočí.
Ako je spomenuté v práci, je potrebné modelovať aj pripočítavanie kľúča, teda bude treba upraviť modul tvoriaci `CipherDescription` pre danú šifru. 
V danom module je použitý `speck_with_key`. 


### Analýza pomocou zámeny prvého/prvých kôl
Toto hľadanie je implementované v module `analysis_blue_optimal`, pretože je v ňom implementované aj hľadanie modrých rozlišovačov s maximálnym počtom konštantných bitov.

V práci spomínaná tvorba boolovských funkcií a simulácia pomocou Solvatore je implementovaná v module `cipher_description_blue`, alebo pre RES je v module `ciphers.RES_blue_manual`.
Vytvorenie `CipherDescription` pre zjednodušenú šifru funguje nasledovne:
* Pre manálnej výrobe funkcií sa inicializuje pomocou `RES_blue_manual.generate_RES(4, blue0, blue1, ls, ssum)`, kde blue0 a blue1 sú indexy modrých bitov a ls a ssum sú konfigurácia šifry. Nepodporuje simuláciu viacerých kôl.
* Pri automatizovanej výrobe funkcií je potrebné najskôr vytvoriť vzorovú funkciu, ktorá je potom argument pre `CipherDescriptionBlue2`. Následne, keď majú byť funkcii priradené modré bity, nastavia sa pomocou funkcie `set_blue_bits`. 
```
cipher = RES_with_key.generate_RES(4, ls, ssum)
imcipher = CipherDescriptionBlue2(cipher, rounds=imrounds, anf=True)
imcipher.set_blue_bits(blue0, blue1)
```  
`cipher` je vzorová šifra, `imrounds` hovorí, koľko kôl má byť zjednodušených. Keď nebude uvedený počet kôl, predpokladá sa 1.

Modul `analysis_blue_optimal` sa dá použiť na vyskúšanie existencie modrého rozlišovača.
To, aká šifra sa overuje je ovládané týmito riadkami
```
ls,ssum, rounds = 2, 6, 7
imrounds = 6
normrounds = rounds - imrounds + 1
cipher = RES_with_key.generate_RES(4, ls, ssum)
imcipher = CipherDescriptionBlue2(cipher, rounds=imrounds, anf=True)
statesize = 4
```
ls, ssum a rounds určujú konfiguráciu šifry RES, v tomto prípade RES(2,6,7). Premenná imrounds určuje, koľko začiatočných kôl sa má použiť na simuláciu.
Ak by za premennú `cipher` bola dosadená iná CipherDescription, výpočet by prebiehal pre tú šifru (je potrebné zmeniť aj statesize -- veľkosť stavu danej šifry).

Modul `analysis_RES_systematic` je modul použitý na výpočet v časti 3.3.5 v práci.

### Extrakcia MCV
Spustiteľný modul `analysis_extract_MCV` je implementácia extrakcie MCV zo Solvatore popísané v práci v časti 3.4

Aktuálne nastavenie je pre generovanie MCV pre RES (2,1,5), ktoré je uvedené v práci. V premennej `distinguiser` sa zadáva, pre aký rozlišovač sa má testovať.
Premenná `blue` hovorí, či sa má použiť zjednodušenie prvých kôl, premenná `imrounds` hovorí koľko kôl.
Môžeme vidieť, ze po zmene imrounds na 4 budú po 5 kolách niektoré MCV s hw 1 nedosiahnuteľné, teda niektorý bit bude balansovaný.  

Ak chceme použiť manuálnu tvorbu boolovských funkcií, treba odkomentovať riadok 
`imcipher = RES_blue_manual.generate_RES(size, blue0, blue1, ls, ssum)`

Ak chceme inú konfiguráciu šifry RES, môžeme upraviť premenné ls, ssum a rounds.
Ak chceme inú šifru, treba zmeniť premennú cipher.