import datetime
from itertools import combinations
from ciphers import speck_with_key
from solvatore_blue1 import SolvatoreBlue1

# First test of short speck with 6 rounds
cipher = speck_with_key.generate_speck_version(8, 7, 2)
rounds = 6
statesize = 16

# Second test of short speck with 7 rounds
# cipher = speck_with_key.generate_speck_version(8, 7, 2)
# rounds = 7
# statesize = 16

# Test of speck32 for 6 rounds
# cipher = speck_with_key.generate_speck_version(16, 7, 2)
# rounds = 6
# statesize = 32

# Test of speck32 for 7 rounds
# cipher = speck_with_key.generate_speck_version(16, 7, 2)
# rounds = 7
# statesize = 32


def getSetOfBalancedBits(constant_bits, bits_to_test):
    active_bits = [i for i in range(statesize) if i not in constant_bits]
    # Compute Set of balanced bits
    B = []
    for i in bits_to_test:
        if solver.is_bit_balanced(i, rounds, active_bits):
            B.append(i)
    return B

good_indices = []
s = list(range(statesize))

# Find blue distinguishers with all bits either active or blue0
for r in range(1,len(s)):
# for r in range(len(s)-1,0, -1):
    for blue0 in combinations(s, r):
        solver = SolvatoreBlue1()
        solver.load_cipher(cipher)
        solver.set_rounds(rounds)
        solver.set_blue_bits(blue0, [])
        constant_bits = list(blue0)
        B = getSetOfBalancedBits(constant_bits, range(statesize))
        if len(B) > 0:
            print("Found distinguisher, blue {}".format(constant_bits + [B]))
            good_indices.append(constant_bits + [B])
    print("Searched all combinations with {} blue0 bits".format(r))

if len(good_indices) == 0:
    print("No distinguisher exists.")
    exit(1)
print(good_indices)