from cipher_description import CipherDescription
#State numbering
#s0... s63
DES = CipherDescription(64)
s = ['s{}'.format(i) for i in range(64)]
t = ['t{}'.format(i) for i in range(64)]

#Re-indexing and adding S-boxes

S1t = [ 14,	4,	13,	1,	2,	15,	11,	8,	3,  10,	6,	12,	5,	9,	0,	7,
        0,	15,	7,	4,	14,	2,	13,	1,	10,	6,	12,	11,	9,	5,	3,	8,
        4,	1,	14,	8,	13,	6,	2,	11,	15,	12,	9,	7,	3,	10,	5,	0,
        15,	12,	8,	2,	4,	9,	1,	7,	5,	11,	3,	14,	10,	0,	6,	13]
S1 = []
for j in range(2):
    for i in range(16):
        S1.extend([S1t[i+32*j],S1t[i+32*j+16]])


S2t = [ 15,	1,	8,	14,	6,	11,	3,	4,	9,	7,	2,	13,	12,	0,	5,	10,
        3,	13,	4,	7,	15,	2,	8,	14,	12,	0,	1,	10,	6,	9,	11,	5,
        0,	14,	7,	11,	10,	4,	13,	1,	5,	8,	12,	6,	9,	3,	2,	15,
        13,	8,	10,	1,	3,	15,	4,	2,	11,	6,	7,	12,	0,	5,	14,	9]
S2 = []
for j in range(2):
    for i in range(16):
        S2.extend([S2t[i+32*j],S2t[i+32*j+16]])
 
S3t = [ 10,	0,	9,	14,	6,	3,	15,	5,	1,	13,	12,	7,	11,	4,	2,	8,
        13,	7,	0,	9,	3,	4,	6,	10,	2,	8,	5,	14,	12,	11,	15,	1,
        13,	6,	4,	9,	8,	15,	3,	0,	11,	1,	2,	12,	5,	10,	14,	7,
        1,	10,	13,	0,	6,	9,	8,	7,	4,	15,	14,	3,	11,	5,	2,	12]
S3 = []
for j in range(2):
    for i in range(16):
        S3.extend([S3t[i+32*j],S3t[i+32*j+16]])
 
S4t = [ 7,	13,	14,	3,	0,	6,	9,	10,	1,	2,	8,	5,	11,	12,	4,	15,
        13,	8,	11,	5,	6,	15,	0,	3,	4,	7,	2,	12,	1,	10,	14,	9,
        10,	6,	9,	0,	12,	11,	7,	13,	15,	1,	3,	14,	5,	2,	8,	4,
        3,	15,	0,	6,	10,	1,	13,	8,	9,	4,	5,	11,	12,	7,	2,	14]
S4 = []
for j in range(2):
    for i in range(16):
        S4.extend([S4t[i+32*j],S4t[i+32*j+16]])

S5t = [ 2,	12,	4,	1,	7,	10,	11,	6,	8,	5,	3,	15,	13,	0,	14,	9,
        14,	11,	2,	12,	4,	7,	13,	1,	5,	0,	15,	10,	3,	9,	8,	6,
        4,	2,	1,	11,	10,	13,	7,	8,	15,	9,	12,	5,	6,	3,	0,	14,
        11,	8,	12,	7,	1,	14,	2,	13,	6,	15,	0,	9,	10,	4,	5,	3]
S5 = []
for j in range(2):
    for i in range(16):
        S5.extend([S5t[i+32*j],S5t[i+32*j+16]])

S6t = [ 12,	1,	10,	15,	9,	2,	6,	8,	0,	13,	3,	4,	14,	7,	5,	11,
        10,	15,	4,	2,	7,	12,	9,	5,	6,	1,	13,	14,	0,	11,	3,	8,
        9,	14,	15,	5,	2,	8,	12,	3,	7,	0,	4,	10,	1,	13,	11,	6,
        4,	3,	2,	12,	9,	5,	15,	10,	11,	14,	1,	7,	6,	0,	8,	13]
S6 = []
for j in range(2):
    for i in range(16):
        S6.extend([S6t[i+32*j],S6t[i+32*j+16]])

S7t = [ 4,	11,	2,	14,	15,	0,	8,	13,	3,	12,	9,	7,	5,	10,	6,	1,
        13,	0,	11,	7,	4,	9,	1,	10,	14,	3,	5,	12,	2,	15,	8,	6,
        1,	4,	11,	13,	12,	3,	7,	14,	10,	15,	6,	8,	0,	5,	9,	2,
        6,	11,	13,	8,	1,	4,	10,	7,	9,	5,	0,	15,	14,	2,	3,	12]
S7 = []
for j in range(2):
    for i in range(16):
        S7.extend([S7t[i+32*j],S7t[i+32*j+16]])
        
S8t = [ 13,	2,	8,	4,	6,	15,	11,	1,	10,	9,	3,	14,	5,	0,	12,	7,
        1,	15,	13,	8,	10,	3,	7,	4,	12,	5,	6,	11,	0,	14,	9,	2,
        7,	11,	4,	1,	9,	12,	14,	2,	0,	6,	10,	13,	15,	3,	5,	8,
        2,	1,	14,	7,	4,	10,	8,	13,	15,	12,	9,	0,	3,	5,	6,	11]
S8 = []
for j in range(2):
    for i in range(16):
        S8.extend([S8t[i+32*j],S8t[i+32*j+16]])
        
DES.add_sbox('S-box1',S1)
DES.add_sbox('S-box2',S2)
DES.add_sbox('S-box3',S3)
DES.add_sbox('S-box4',S4)
DES.add_sbox('S-box5',S5)
DES.add_sbox('S-box6',S6)
DES.add_sbox('S-box7',S7)
DES.add_sbox('S-box8',S8)

#F function
#Expansion
E = [32,1,2,3,4,5,
     4,5,6,7,8,9,
     8,9,10,11,12,13,
     12,13,14,15,16,17,
     16,17,18,19,20,21,
     20,21,22,23,24,25,
     24,25,26,27,28,29,
     28,29,30,31,32,1]
     
for i in range(48):
    DES.apply_mov(s[32+E[i]-1],t[i])
        

#S-box layer
for i in range(1,9):
    input_bits = t[(i-1)*6:i*6]
    output_bits = t[(i-1)*4:i*4]

    DES.apply_sbox('S-box{}'.format(i),input_bits,output_bits)

#P-box 
P = [   16,	7,	20,	21,	29,	12,	28,	17,
        1,	15,	23,	26,	5,	18,	31,	10,
        2,	8,	24,	14,	32,	27,	3,	9,
        19,	13,	30,	6,	22,	11,	4,	25]

for i in range(32):
    DES.apply_mov(t[P[i]-1],t[32+i])

#Compression 
for i in range(32):
    DES.apply_xor(s[i],t[32+i],s[i])
#swap
shuffle = [1,0]
DES.shufflewords(shuffle,32,0)

