from cipher_description import CipherDescription


def generate_RES(size, lshift, ssum):
    RES = CipherDescription(size)
    bits = ["s{}".format(x) for x in range(size)]

    # Add the appropriate sbox
    sbox = [(x + ssum) % (2**size) for x in range(2 ** size)]
    RES.add_sbox('S-box', sbox)
    RES.apply_sbox('S-box', bits, bits)

    # application of lshift
    if lshift != 0:
        if size % lshift == 0:
            for j in range(lshift):
                shift = ['s{}'.format(j + i * lshift) for i in range(size / lshift)]
                RES.apply_permutation(shift)
        else:
            shift = ['s{}'.format((i * lshift) % size) for i in range(size)]
            RES.apply_permutation(shift)
    return RES

