from cipher_description import CipherDescription

fly_sbox = [0, 110, 171, 231, 52, 127, 35, 246, 157,
            193, 18, 77, 138, 208, 184, 92, 230, 187,
            101, 48, 93, 172, 222, 154, 72, 47, 207, 137,
            251, 19, 116, 1, 186, 86, 51, 117, 64, 23, 2,
            97, 244, 40, 200, 159, 173, 233, 219, 131, 126,
            3, 87, 170, 133, 203, 232, 185, 145, 220, 45, 65,
            98, 63, 26, 240, 67, 213, 4, 88, 34, 129, 201,
            29, 108, 114, 150, 250, 183, 174, 224, 55, 247,
            202, 113, 188, 24, 153, 143, 66, 89, 228, 211, 46,
            54, 5, 165, 107, 50, 237, 32, 142, 156, 248, 68,
            223, 199, 27, 121, 100, 83, 6, 166, 181, 111, 169,
            22, 155, 209, 36, 253, 204, 128, 69, 236, 82, 190,
            122, 7, 62, 217, 132, 79, 25, 198, 149, 124, 8,
            85, 163, 103, 59, 225, 178, 254, 42, 28, 242, 130,
            205, 39, 78, 177, 84, 58, 119, 160, 229, 9, 104, 147,
            214, 33, 252, 140, 210, 105, 61, 151, 206, 118, 10,
            238, 176, 21, 75, 95, 164, 212, 152, 249, 20, 175,
            226, 70, 37, 179, 94, 11, 102, 192, 135, 60, 125,
            168, 191, 218, 38, 123, 99, 53, 235, 30, 144, 81,
            12, 255, 196, 141, 73, 13, 49, 158, 243, 234, 80,
            96, 167, 43, 134, 180, 120, 76, 221, 194, 31, 139,
            71, 189, 161, 14, 90, 106, 112, 239, 57, 245, 195,
            216, 44, 17, 146, 197, 16, 56, 15, 115, 182, 91,
            227, 162, 109, 74, 215, 148, 241, 41, 136]

fly_permutations = [\
  ['s1', 's9', 's17', 's25', 's33', 's41', 's49', 's57'],
  ['s2', 's18', 's34', 's50'],
  ['s10', 's26', 's42', 's58'],
  ['s4', 's36'],
  ['s12', 's44'],
  ['s20', 's52'],
  ['s28', 's60'],
  ['s5', 's45', 's21', 's61', 's37', 's13', 's53', 's29'],
  ['s6', 's54', 's38', 's22'],
  ['s14', 's62', 's46', 's30'],
  ['s7', 's63', 's55', 's47', 's39', 's31', 's23', 's15']
  ]

fly = CipherDescription(64)
fly.add_sbox('S-box', fly_sbox)
for i in range(8):
    bits = ["s{}".format(8*i + 0),
            "s{}".format(8*i + 1),
            "s{}".format(8*i + 2),
            "s{}".format(8*i + 3),
            "s{}".format(8*i + 4),
            "s{}".format(8*i + 5),
            "s{}".format(8*i + 6),
            "s{}".format(8*i + 7)]
    fly.apply_sbox('S-box', bits, bits)
for p in fly_permutations:
    fly.apply_permutation(p)
