import java.util.ArrayList;

public class ColorabilityTester {
    ArrayList<ArrayList<Integer>> graph;
    ArrayList<Boolean> visited = new ArrayList<>();
    int N;
    ArrayList<ArrayList<Integer>> perfMatchings = new ArrayList<>();
    boolean hasLoop = false;
    boolean hasNoColorMatching = false;

    ColorabilityTester(ArrayList<ArrayList<Integer>> graph) {
        this.graph = new ArrayList<>();
        N = graph.size();
        for (int i = 0; i < N; i++) {
            this.graph.add(new ArrayList<>());
            this.graph.get(i).addAll(graph.get(i));
            visited.add(false);
        }
    }

    /*hladanie vsetkych perfektnych pareni - rekurziou pridava a odobera navstivene vrcholy*/
    boolean findPerfectMatching(Integer vertex, ArrayList<Integer> tempMatch, boolean isMatched, int counter) {
        if (counter == N) {
            ArrayList<Integer> cpMatch = new ArrayList<>();
            cpMatch.addAll(tempMatch);
            perfMatchings.add(cpMatch);
            return true;
        }
        boolean result = false;
        for (Integer neighbor : graph.get(vertex)) {
            if (!visited.get(neighbor)) {
                visited.set(neighbor, true);
                tempMatch.add(neighbor);
                if (isMatched) {
                    result = findPerfectMatching(neighbor, tempMatch,false, counter);
                } else {
                    result = findPerfectMatching(neighbor, tempMatch,true, counter+2);
                }
                visited.set(neighbor, false);
                tempMatch.remove((Object) neighbor);
            }
        }
        return result;
    }

    boolean containsLoop(){
        boolean containsLoop = false;
        for(int i = 0; i < N; i++) {
            if(graph.get(i).contains(i)) {
                containsLoop = true;
                graph.get(i).remove((Object)i);
            }
        }
        return containsLoop;
    }

    boolean isInEvenCycle(int index, ArrayList<ArrayList<Integer>> cycGraph){
        visited.set(index, true);
        int following = cycGraph.get(index).get(0);
        /*ak idu obe hrany do toho isteho vrcholu*/
        if(following == cycGraph.get(index).get(1)) {
            visited.set(following, true);
            return true;
        }
        int counter = 1;
        int prev = index;
        /*posuvanie po kruznici, kym neprideme na zaciatok*/
        while(following != index) {
            visited.set(following, true);
            counter++;
            int temp = following;
            if (cycGraph.get(following).get(0) == prev) {
                following = cycGraph.get(following).get(1);
            } else {
                following = cycGraph.get(following).get(0);
            }
            prev = temp;
        }
        return counter % 2 == 0;
    }

    /*testuje zafarbitelnost pri pareni danom indexom do pola vsetkych najdenych pareni*/
    boolean isColorableMatching(int matchinIndex){
        ArrayList<Integer> matching = perfMatchings.get(matchinIndex);
        ArrayList<ArrayList<Integer>> tempGraph = new ArrayList<>();
        for (int i = 0; i < N; i++) {
            tempGraph.add(new ArrayList<>());
            tempGraph.get(i).addAll(graph.get(i));
            visited.set(i,false);
        }
        int v1 = 0;
        int v2;
        //vyhodim hrany z parenia
        while(v1 < N) {
            v2 = v1+1;
            tempGraph.get(matching.get(v1)).remove((Object) matching.get(v2));
            tempGraph.get(matching.get(v2)).remove((Object) matching.get(v1));
            v1 = v1+2;
        }
        /*skusim, ci vsetky kruznice su parne*/
        boolean allCycEven = true;
        for (int i = 0; i < N; i++) {
            if(!visited.get(i)){
                allCycEven = isInEvenCycle(i, tempGraph);
            }
            if (!allCycEven) {
                return false;
            }
        }
        return true;
    }

    /*vrati 3-zafarbitelnost grafu*/
    boolean isColorable(){
        /*graf je prazdny*/
        if(N == 0) {
            return true;
        }

        if(containsLoop()) {
            hasLoop = true;
            return false;
        }

        visited.set(0, true);
        ArrayList<Integer> tempMatch = new ArrayList<>();
        tempMatch.add(0);
        /*najdem vsetky mozne parenia a pridam ich do perfMatchings*/
        findPerfectMatching(0, tempMatch,false, 0);
        int numMatchings = perfMatchings.size();

        /*pre vsetky parenia testujem, ci su zafarbitelne*/
        for (int i = 0; i < numMatchings; i++) {
            if (isColorableMatching(i)) {
                return true;
            }
        }
        hasNoColorMatching = true;
        return false;
    }

}
