import java.util.ArrayList;
import java.util.TreeMap;

/*trieda sluzi na rozpustanie parnych kruznic v grafe*/
public class CycleDissolver {
    ArrayList<ArrayList<Integer>> originalGraph;
    ArrayList<Integer> cycle;
    boolean red; //ak true, odstranujeme "cervene hrany" - neparne, ak false, tak parne
    ArrayList<Integer> toBeRemoved = new ArrayList<>();

    /*konstruktor zaroven preraba reprezentaciu grafu maticou susednosti na zoznamy susedov*/
    CycleDissolver(ArrayList<ArrayList<Integer>> originalGraph, ArrayList<Integer> cycle, boolean red) {
        this.cycle = new ArrayList<>();
        this.cycle.addAll(cycle);
        this.originalGraph = new ArrayList<>(originalGraph.size());
        for (int i = 0; i < originalGraph.size(); i++) {
            this.originalGraph.add(new ArrayList<>());
            for (int j = 0; j < originalGraph.size(); j++) {
                if(originalGraph.get(i).get(j) == 1) this.originalGraph.get(i).add(j);
            }
        }
        this.red = red;
    }

    ArrayList<ArrayList<Integer>> getDissolvedGraph() {
        //odstrani hrany
        removeEdges();

        //postupne prechadza vrcholy cyklu a rozpusta ich
        TreeMap<Integer, Boolean> visited = new TreeMap<>();
        for (Integer v : cycle) {
            visited.put(v,false);
        }
        for(Integer v : cycle) {
            if(!visited.get(v)) {
                visited.replace(v, true);
                /*vrcholy kruznice maju v grafe po odstraneni hran kruznice parny stupen
                 - urcime najprv, ktory vrchol je susedom v kruznici a ktory je druhym koncom*/
                int cycNeigh = -1;
                int end1 = -1;
                for(Integer neighbor : originalGraph.get(v)) {
                    if(isNeighbourInCyc(v, neighbor)) {
                        cycNeigh = neighbor;
                    } else {
                        end1 = neighbor;
                    }
                }
                visited.replace(cycNeigh, true);
                toBeRemoved.add(v);
                toBeRemoved.add(cycNeigh);
                /*ak sa end1 nachadza v kruznici, znamena to, ze existuje chorda a musime hladat dlhsiu cestu, ktoru
                celu rozpustime*/
                if (cycle.contains(end1)) {
                    visited.replace(end1, true);
                    end1 = findPathEnd(v,end1, visited);
                    /*skontrolujeme, ci sa najdeny koniec cesty zhoduje s nasim zacinajucim vrcholom. Ak nie, najdeme este
                    druhy koniec a pridame novu hranu do grafu. Pamatame si, ktore vrcholy treba vyhodit. Ak sa zhoduje,
                    z cesty sa stala kruznica, ktoru celu odstranime a tym padom nepridame ziadnu novu hranu*/
                    if(v != end1) {
                        int end2 = findEnd2(v, cycNeigh, visited);
                        if (toBeRemoved.contains(end1)) {
                            toBeRemoved.remove((Object)end1);
                        }
                        if (toBeRemoved.contains(end2)) {
                            toBeRemoved.remove((Object)end2);
                        }
                        originalGraph.get(end1).add(end2);
                        if(end1 != end2) {
                            originalGraph.get(end2).add(end1);
                        }
                    }
                } else {
                    /*ak cyklus neobsahoval end1, najdeme end2 pre suseda v v kruznici
                    * kedze end1 nebol v povodnej kruznici, vieme, ze end2 v nej tiez neskonci a urcite pridame novu hranu*/
                    int end2 = findEnd2(v, cycNeigh, visited);
                    if (toBeRemoved.contains(end1)) toBeRemoved.remove((Object)end1);
                    if (toBeRemoved.contains(end2)) toBeRemoved.remove((Object)end2);
                    originalGraph.get(end1).add(end2);
                    if(end1 != end2) {
                        originalGraph.get(end2).add(end1);
                    }
                }
            }
        }
        /*odstranime rozpustene vrcholy*/
        for (Integer ver : toBeRemoved) {
            for(Integer neigh : originalGraph.get(ver)) {
                originalGraph.get(neigh).remove(ver);
            }
            originalGraph.get(ver).clear();
        }
        return originalGraph;
    }

    /*vrati ci su indexy i a j susedne v kruznici*/
    boolean isNeighbourInCyc(Integer i, Integer j) {
        if (cycle.contains(j)) {
            if (cycle.indexOf(i) == 0) {
                if (cycle.indexOf(j) == cycle.size() - 1) return true;
            }
            if (cycle.indexOf(j) == 0) {
                if (cycle.indexOf(i) == cycle.size() - 1) return true;
            }
            if ((cycle.indexOf(i) == cycle.indexOf(j) - 1) || (cycle.indexOf(j) == cycle.indexOf(i) - 1)) return true;
        }
        return false;
    }

    /*Najde koniec cesty do ktorej sa dostane z vrcholu v.
    Koniec moze (pokojne aj po nejakom useku stravenom v cykle) lezat mimo cyklu. V tom pripade sa cesta rozpusti na hranu.
     V druhom pripade sa cesta zacykli a skonci opat vo v. V tomto pripade sa vymaze.*/
    int findEnd2(int v, int cycNeigh, TreeMap<Integer,Boolean> visited) {
        int end2 = -1;
        for(Integer neighbor : originalGraph.get(cycNeigh)) {
            if(!isNeighbourInCyc(cycNeigh, neighbor)) {
                end2 = neighbor;
            }
        }
        if (cycle.contains(end2)) {
            visited.replace(end2, true);
            end2 = findPathEnd(cycNeigh, end2, visited);
        }
        return end2;
    }

    /*Pomocna funkcia, ktora chodenim po kruznici hlada koniec cesty, ktora sa rozpusti. Pamata si, ktore vrcholy kruznice uz navstivila
    a pridava vrcholy do zoznamu, ktory bude neskor odstraneny z grafu.*/
    Integer findPathEnd(int prev, int next, TreeMap<Integer, Boolean> visited){
        int following = -1;
        for(Integer neigh : originalGraph.get(next)) {
            if (neigh != prev) following = neigh;
        }
        toBeRemoved.add(next);
        toBeRemoved.add(following);
        while(following != prev && cycle.contains(following)){
            visited.replace(following, true);
            int toBeFollowing = next;
            for(Integer neigh : originalGraph.get(following)) {
                if (neigh != next) {
                    toBeFollowing = neigh;
                }
            }
            next = following;
            following = toBeFollowing;
            toBeRemoved.add(following);
        }
        return following;
    }

    /*Odstrani hrany parneho cyklu - kazdu parnu, alebo kazdu neparnu, podla toho, ci je nastavena cervena, alebo nie je.*/
    void removeEdges() {
        int sizeC = cycle.size();
        if (red) {
            for (int i = 0; i < sizeC; i = i+2) {
                originalGraph.get(cycle.get(i)).remove(cycle.get(i+1));
                originalGraph.get(cycle.get(i+1)).remove(cycle.get(i));
            }
        } else {
            for (int i = 1; i < sizeC - 1; i = i+2) {
                originalGraph.get(cycle.get(i)).remove(cycle.get(i+1));
                originalGraph.get(cycle.get(i+1)).remove(cycle.get(i));
            }
            originalGraph.get(cycle.get(0)).remove(cycle.get(sizeC-1));
            originalGraph.get(cycle.get(sizeC-1)).remove(cycle.get(0));
        }
    }



}
