import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

/*Trieda triedi dvojice, ktore chybaju v kruzniciach dlzky n-2 na take, ktore chybaju iba v rozpustnych, alebo aj
v rozpustnych aj v nerozpustnych kruzniciach. */
public class OnCycles {

    OnCycles(){}

    void detectVerticesNotInCycle() throws IOException {
        int x, y;
        for (int i = 1; i < 5; i++) {
            int numV = (i+1)*8+2;
            String inF = "./results/cycles/n-2/Blanusa/rozpustne/B"+i+"_rozpustne_"+numV+".txt";
            Scanner scanner = new Scanner(new File(inF));
            ArrayList<MyPair> solluablePairs = new ArrayList<>();
            while (scanner.hasNext()){
                x = scanner.nextInt();
                y = scanner.nextInt();
                solluablePairs.add(new MyPair(x,y));
            }
            inF = "./results/cycles/n-2/Blanusa/nerozpustne/B"+i+"_1_nerozpustne_"+numV+".txt";
            scanner = new Scanner(new File(inF));
            BufferedWriter sameWriter = new BufferedWriter(new FileWriter("./results/cycles/n-2/Blanusa/comparing/B" + i + "_same_misses_" + numV + ".txt"));
            BufferedWriter notsameWriter = new BufferedWriter(new FileWriter("./results/cycles/n-2/Blanusa/comparing/B" + i + "_not_same_misses_" + numV + ".txt"));
            sameWriter.append("Tu su dvojice, ktore chybaju aj v rozpustitelnych kruzniciach, aj v jednostranne nerpzpustitelnych kruzniciach\n");
            notsameWriter.append("Tu su dvojice, ktore chybaju jednostranne nerozpustitelnych kruzniciach, ale nechybaju v rozpustitelnych\n");
            while (scanner.hasNext()) {
                x = scanner.nextInt();
                y = scanner.nextInt();
                MyPair pair = new MyPair(x,y);
                if (solluablePairs.contains(pair)) {
                    sameWriter.append(x + " " + y + "\n");
                } else {
                    notsameWriter.append(x + " " + y + "\n");
                }

            }
            sameWriter.close();
            notsameWriter.close();
        }
    }

}
