import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

/*Tester berie graf z konzoly a podla zvoleneho modu  vypise bud ci nasiel jednu rozpustnu kruznicu, alebo vypise vsetky rozpustne
kruznice, ktore v grafe nasiel.
 */
public class Tester {

    BufferedWriter writer;
    BufferedWriter sepWriter;
    int numV;
    int counter;
    int cycCounter, solCycCounter;
    ArrayList<ArrayList<Integer>> graph;
    Boolean findAll;

    Tester(int numV, Boolean findAll) {
        this.numV = numV;
        this.findAll = findAll;
    }

    void runFromConsole() throws  IOException {
        Scanner s = new Scanner(System.in);
        graph = new ArrayList<>();
        for (int i = 0; i < numV; i++) {
            ArrayList<Integer> zeroLine = new ArrayList<>();
            for (int k = 0; k < numV; k++) {
                zeroLine.add(0);
            }
            graph.add(zeroLine);
            for (int j = 0; j < 3; j++) {
                graph.get(i).set(s.nextInt(), 1);
            }
        }

        if (findAll) {
            detectAllDissolvableCycles();
        } else {
            detectIfGraphContainsAtLeastOneDissolvableCycle();
        }
    }

    /*Najde vsetky rozpustitelnene kruznice */
    void detectAllDissolvableCycles() {
        CycleDetector detector = new CycleDetector(graph);
        detector.computeCycles();
        cycCounter = 0;
        solCycCounter = 0;

        for (ArrayList<Integer> cyc : detector.cycles) {
            if ((cyc.size() % 2) == 0) {
                cycCounter++;
                CycleDissolver dissolver = new CycleDissolver(graph, cyc, true);
                ArrayList<ArrayList<Integer>> resultGraph = dissolver.getDissolvedGraph();
                GraphShrinker shrinker = new GraphShrinker(resultGraph);
                ColorabilityTester tester1 = new ColorabilityTester(shrinker.graph);
                boolean G1Colorable = tester1.isColorable();
                dissolver = new CycleDissolver(graph, cyc, false);
                resultGraph = dissolver.getDissolvedGraph();
                shrinker = new GraphShrinker(resultGraph);
                ColorabilityTester tester2 = new ColorabilityTester(shrinker.graph);
                boolean G2Colorable = tester2.isColorable();
                if (!G1Colorable && !G2Colorable) {
                    System.out.println(cyc);
                    solCycCounter++;
                }
            }
        }

        if (cycCounter > 0) {
             System.out.println(solCycCounter + "/" + cycCounter + " cycles of even length are soluble.");
        } else {
            System.out.println("Does not contain even cycles.");
        }
    }

    void detectIfGraphContainsAtLeastOneDissolvableCycle() throws IOException {
        CycleDetector detector= new CycleDetector(graph);
        boolean hasDissolvableCycle = detector.computeCyclesAndTryToDissolve();
        if(hasDissolvableCycle) {
            System.out.println("Graph contains soluble cycle.");
            System.out.println(detector.dissolvableCycle);
        } else {
            System.out.println("Graph does not contain any soluble cycle.");
        }
    }



}
