#pragma once
class FlightPath
{
public:
	FlightPath::FlightPath(
		CapturingReality::CoordinateSystemPoint start,
		CollisionDetector *ColDet,
		const double &xSize,
		const double &ySize,
		const double &zSize,
		const double &xOff,
		const double &yOff,
		const double &zOff,
		const double &divSize,
		const double &radius,
		const double &maxDistance);

	~FlightPath();
	std::vector<CapturingReality::CoordinateSystemPoint> GetPoints();
	std::vector<std::vector<CapturingReality::CoordinateSystemPoint>> FlightPath::Paths(
		std::vector<CapturingReality::CoordinateSystemPoint> &cameras,
		std::vector<CapturingReality::CoordinateSystemPoint> &looks,
		std::vector<CapturingReality::CoordinateSystemPoint> &lookAts,
		std::vector<bool> &mask
	);
	void Discover(int x, int y, int z);

private:
	CapturingReality::CoordinateSystemPoint strt;
	CollisionDetector *cd;
	bool*** bitmap;
	bool*** discovered;
	int xMapSize, yMapSize, zMapSize;
	double max_dist;
	double cellSize;
	double *size, *offset;

	inline int MapXPos(double xPos) { return std::round((xPos + (size[0] / 2) - offset[0]) / cellSize); }
	inline int MapYPos(double yPos) { return std::round((yPos - offset[1]) / cellSize); }
	inline int MapZPos(double zPos) { return std::round((zPos + (size[2] / 2) - offset[2]) / cellSize); }

	inline double EuclideanDistance(CapturingReality::CoordinateSystemPoint point1, CapturingReality::CoordinateSystemPoint point2)
	{
		return sqrt(pow(point1.x - point2.x, 2) + pow(point1.y - point2.y, 2) + pow(point1.z - point2.z, 2));
	}
	
};

