#pragma once

#include "dbscan.h"

HRESULT DeleteFaces(
	__in double maximalEdgeLength,
	__in double minimalEdgeLength,
	__in CapturingReality::Mvs::IMvsModel *pMvsModel,
	__deref_out CapturingReality::Mvs::IMvsModel **ppMvsModel);

HRESULT GetNormalsFromModel(
	__in CapturingReality::Mvs::IMvsModel *pMvsModel,
	__out std::vector<CapturingReality::CoordinateSystemPoint> &normals);

HRESULT GetPointsFromModel(
	__in CapturingReality::Mvs::IMvsModel *pMvsModel,
	__out std::vector<CapturingReality::CoordinateSystemPoint> &points);

void GetAvgClustersAndNormals(
	__in std::vector<CapturingReality::CoordinateSystemPoint> &points,
	__in std::vector<int> &pointsClusterId,
	__in std::vector<CapturingReality::CoordinateSystemPoint> &normals,
	__out std::vector<CapturingReality::CoordinateSystemPoint> &avg_clusters,
	__out std::vector<CapturingReality::CoordinateSystemPoint> &avg_normals);

