#include "stdafx.h"
#include "Photogrammetry.h"

HRESULT CreateReconstruction(
	__in CapturingReality::IResourceCache *pCache,
	__in CapturingReality::IConfig *pConfig,
	__in std::vector<std::vector<CapturingReality::CoordinateSystemPoint>> CameraPositions,
	__deref_out CapturingReality::Sfm::IStructureFromMotion **ppSfm,
	__deref_out CapturingReality::Sfm::ISfmReconstruction **pRecon
)
{
	HRESULT hr;

	std::wstring Path = L"..\\Resources\\Simulations\\";

	printf("SFM: Starting\n");
	UINT maxCams = 0;
	CComPtr< CapturingReality::Sfm::ISfmReconstruction > spMaxReconstruction;
	CComPtr< CapturingReality::Sfm::IStructureFromMotion > spSfm;

	hr = CapturingReality::Sfm::CreateSfmPipeline(pConfig, NULL, NULL, NULL, NULL, NULL, &spSfm);
	if (FAILED(hr))
		return hr;

	for (int i = 0; i < CameraPositions.size(); i++)
	{
		for (int j = 0; j < CameraPositions[i].size(); j++) {
			std::wstring pic_path = Path + std::to_wstring(i + 1) + L"\\" + std::to_wstring(i + 1) + L"_" + std::to_wstring(j) + L".jpg";
			CComPtr<ISfmStreamInput> spInput;
			hr = spSfm->AddImage(pic_path.c_str(), NULL, NULL, &spInput);
			if (FAILED(hr)) return hr;

			CComQIPtr<ISfmImage> spImage = spInput;
			if (spImage != NULL)
			{
				/*SfmImageParametersGroups g;
				g.calibrationGroup = 1;
				g.distortionGroup = 1;
				spImage->SetParameterGrouping(g);*/

				CapturingReality::SfmCameraCalibration K = { 0 };
				K.K.aspectRatio = 1;
				K.K.focalLength = 0.5 / tan(35.0 * DEG_TO_RAD);
				spImage->SetCalibration(
					&K,
					(SfmCameraCalibrationFlags)(SfmCameraCalibrationFlags::SCCF_FOCAL_LENGTH_EXACT | SfmCameraCalibrationFlags::SCCF_ASPECT_EXACT | SfmCameraCalibrationFlags::SCCF_PRINCIPAL_EXACT | SfmCameraCalibrationFlags::SCCF_SKEW_EXACT),
					CapturingReality::SfmLensDistortionModel::SFMLDM_NONE
				);
			}
		}
	}

	//If you wish to receive progress information or add ability to abort registration process, implement IProgressReport and pass it to RegisterImages.
	printf("SFM: Registering Images\n");
	hr = spSfm->RegisterImages(NULL);

	if (FAILED(hr))
		return hr;

	hr = UnlockReconstructionsIfNeeded(spSfm);
	if (FAILED(hr))
		return hr;


	if (SUCCEEDED(hr))
	{
		// select a component of the maximal size
		UINT recCount = spSfm->GetReconstructionsCount();
		printf("Calculated %d components\n", recCount);
		for (UINT i = 0; i < recCount; i++)
		{
			CComPtr<CapturingReality::Sfm::ISfmReconstruction> spReconstruction;
			hr = spSfm->GetReconstruction(i, &spReconstruction);
			if (FAILED(hr))
			{
				return hr;
			}

			UINT registeredCamerasCount = spReconstruction->GetCamerasCount();
			if (registeredCamerasCount > maxCams)
			{
				spMaxReconstruction = spReconstruction;
				maxCams = registeredCamerasCount;
			}
		}

		if (!spMaxReconstruction)
		{
			// nothing to do
			return E_ABORT;
		}

		// print some stats
		UINT camerasCount = spMaxReconstruction->GetCamerasCount();
		UINT pointsCount;
		hr = spMaxReconstruction->GetStructureSize(&pointsCount);
		if (FAILED(hr))
		{
			return hr;
		}

		printf("SFM: biggest component has %d cameras registered and %d points\n", camerasCount, pointsCount);

	}

	if (SUCCEEDED(hr))
	{
		hr = spSfm.CopyTo(ppSfm);
	}

	if (SUCCEEDED(hr))
	{
		hr = spMaxReconstruction.CopyTo(pRecon);
	}

	return hr;
}
