#pragma once
class PointCloudTransformation
{
public:
	PointCloudTransformation(
		__in CapturingReality::Sfm::IStructureFromMotion *pSfm,
		__in CapturingReality::Sfm::ISfmReconstruction *pRec,
		__in std::vector<std::vector<CapturingReality::CoordinateSystemPoint>> &CameraPosition);

	void CalculateTransformation();

	double GetScale() { return scale; }
	double* GetTranslate() { return T; }
	double* GetRotation() { return R; }

	void GetTransformation(CapturingReality::CoordinateSystemResidual &transform)
	{
		transform.s = scale;
		
		transform.R[0] = R[0];
		transform.R[1] = R[1];
		transform.R[2] = R[2];
		transform.R[3] = R[3];
		transform.R[4] = R[4];
		transform.R[5] = R[5];
		transform.R[6] = R[6];
		transform.R[7] = R[7];
		transform.R[8] = R[8];

		transform.t[0] = T[0];
		transform.t[1] = T[1];
		transform.t[2] = T[2];
	}

	std::vector<CapturingReality::CoordinateSystemPoint> GetSfmCameras() {
		
		std::vector<CapturingReality::CoordinateSystemPoint> sfmCams;

		for (int i = 0; i < sfmCameras.size(); i++)
			sfmCams.push_back(sfmCameras[i]);

		return sfmCams;
	}

	std::vector<CapturingReality::CoordinateSystemPoint> GetCameras() {

		std::vector<CapturingReality::CoordinateSystemPoint> Cams;

		for (int i = 0; i < cameras.size(); i++)
			Cams.push_back(cameras[i]);

		return Cams;
	}

	void TransformPoints(std::vector<CapturingReality::CoordinateSystemPoint> &points);
	void TransformPoint(CapturingReality::CoordinateSystemPoint &point);

private:
	double scale;
	double *T;
	double *R;

	std::vector<CapturingReality::CoordinateSystemPoint> cameras;
	std::vector<CapturingReality::CoordinateSystemPoint> sfmCameras;

	void GetMatchFromName(
		__in std::string &image_name,
		__out UINT &sim,
		__out UINT &image);

	inline double EuclideanDistance(CapturingReality::CoordinateSystemPoint point1, CapturingReality::CoordinateSystemPoint point2)
	{
		return sqrt(pow(point1.x - point2.x, 2) + pow(point1.y - point2.y, 2) + pow(point1.z - point2.z, 2));
	}
};

