#include "stdafx.h"
#include "FloydWarshall.h"
#include "TSP.h"


TSP::TSP(int size)
{
	g.resize(size);
	for (auto &row : g) {
		row.resize(size, INF);
	}
	component.resize(size, false);
}


TSP::~TSP()
{
}

void TSP::setDistance(int u, int v, double dist) {
	g[u][v] = g[v][u] = dist;
}

void TSP::setPath(
	int u,
	int v,
	double dist,
	std::vector<CapturingReality::CoordinateSystemPoint> &path,
	std::vector<std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>> &paths)
{

	std::vector<CapturingReality::CoordinateSystemPoint> detourpath = path;
	double d = dist;

	for (int k = 0; k < g.size(); k++) {
		if ((g[u][k] + g[k][v]) < d) {
			d = g[u][k] + g[k][v];
			detourpath.clear();
			if (paths[u][k].size() > 1) detourpath.insert(detourpath.end(), paths[u][k].begin(), paths[u][k].end()-1);
			detourpath.insert(detourpath.end(), paths[k][v].begin(), paths[k][v].end());
		}

	}
	g[u][v] = g[v][u] = d;
	paths[u][v] = detourpath;
	paths[v][u] = detourpath;

	std::reverse(paths[v][u].begin(), paths[v][u].end());

	for (int k = 0; k < g.size(); k++)
	{
		if ((g[k][u] + d) < g[k][v] && g[k][v] != INF)
		{
			double d2 = g[k][u] + d;
			std::vector<CapturingReality::CoordinateSystemPoint> tmp;
			g[k][v] = INF;
			g[v][k] = INF;
			paths[k][v].clear();
			paths[v][k].clear();

			if(paths[k][u].size() > 1) tmp.insert(tmp.end(), paths[k][u].begin(), paths[k][u].end()-1);
			tmp.insert(tmp.end(), detourpath.begin(), detourpath.end());

			setPath(k, v, d2, tmp, paths);
		}
		if ((d + g[v][k]) < g[u][k] && g[u][k] != INF)
		{
			double d2 = d + g[v][k];
			std::vector<CapturingReality::CoordinateSystemPoint> tmp;
			g[u][k] = INF;
			g[k][u] = INF;
			paths[u][k].clear();
			paths[k][u].clear();

			if (detourpath.size() > 1) tmp.insert(tmp.end(), detourpath.begin(), detourpath.end()-1);
			tmp.insert(tmp.end(), paths[v][k].begin(), paths[v][k].end());

			setPath(u, k, d2, tmp, paths);
		}
	}	
}

void TSP::reduceToComponent(
	const int &initial_vertex,
	std::vector<std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>> &pths,
	std::vector<CapturingReality::CoordinateSystemPoint> &cams,
	std::vector<CapturingReality::CoordinateSystemPoint> &lks)
{
	calc_component(initial_vertex);
	std::vector<std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>> new_pths;
	std::vector<CapturingReality::CoordinateSystemPoint> new_cams;
	std::vector<CapturingReality::CoordinateSystemPoint> new_lks;
	std::vector<std::vector<double>> new_g;

	for (int i = 0; i < component.size()-1; i++) { //last vertex is the starting point
		if (component[i] == true) {
			new_cams.push_back(cams[i]);
			new_lks.push_back(lks[i]);
		}
	}
	new_pths.resize(new_cams.size() + 1); //for the last vertex
	new_g.resize(new_cams.size() + 1);
	int idx = 0;
	for (int i = 0; i < component.size(); i++) {
		if (component[i] == true) {
			new_pths[idx].resize(new_cams.size() + 1);
			new_g[idx].resize(new_cams.size() + 1);
			int idy = 0;
			for (int j = 0; j < component.size(); j++) {
				if (component[j] == true) {
					new_pths[idx][idy] = pths[i][j];
					new_g[idx][idy] = g[i][j];
					idy++;
				}
			}
			idx++;
		}
	}

	cams = new_cams;
	lks = new_lks;
	pths = new_pths;
	g = new_g;
}

bool TSP::isHoldingTriangleInequality() {

	bool holds = true;

	for (int i = 0; i < g.size(); i++)
	{
		for (int j = 0; j < g.size(); j++)
		{
			for (int k = 0; k < g.size(); k++)
			{
				if ((g[i][j] + g[j][k]) < g[i][k] && g[i][k] != INF) {
					holds = false;

					std::cout << (g[i][j] + g[j][k]) << " = " << i << "-" << j << "-" << k << " < " << g[i][k] << std::endl;
				}
			}
		}
	}

	if (holds) printf("Holds triangle inequality\n");
	else printf("Do not holds triangle inequality\n");

	return holds;
}

void TSP::fillPaths(
	std::vector<std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>> &pths)
{
	FloydWarshall fw;
	fw.solve(g);

	for (int u = 0; u < g.size(); u++) {
		for (int v = 0; v < g.size(); v++) {
			if (u != v && g[u][v] == INF) {
				double d = fw.getCost(u, v);
				std::vector<CapturingReality::CoordinateSystemPoint> pth = fw.getPath(u, v, pths);
				setPath(u, v, d, pth, pths);
			}
		}
	}
}

void TSP::calc_component(int initial_vertex)
{
	component[initial_vertex] = true;
	for (int i = 0; i < g[initial_vertex].size(); i++)
	{
		if (g[initial_vertex][i] != INF && !component[i]) {
			calc_component(i);
		}
	}
}

bool TSP::isValidEdge(int u, int v, std::vector<bool> &inMST)
{
	if (u == v)
		return false;
	if (inMST[u] == false && inMST[v] == false)
		return false;
	else if (inMST[u] == true && inMST[v] == true)
		return false;
	return true;
}

void TSP::primMST()
{
	std::vector<bool> inMST(g.size(), false);

	// Include first vertex in MST 
	inMST[g.size() - 1] = true;
	visited.resize(g.size(), false);
	mst.resize(g.size());

	// Keep adding edges while number of included 
	// edges does not become V-1. 
	int edge_count = 0;
	double mincost = 0;
	while (edge_count < g.size() - 1) {

		// Find minimum weight valid edge.   
		double min = INF;
		int a = -1, b = -1;
		for (int i = 0; i < g.size(); i++) {
			for (int j = 0; j < g.size(); j++) {
				if (g[i][j] < min) {
					if (isValidEdge(i, j, inMST)) {
						min = g[i][j];
						a = i;
						b = j;
					}
				}
			}
		}
		if (a != -1 && b != -1) {
			edge_count++;

			mst[a].push_back(b);
			mst[b].push_back(a);

			inMST[b] = inMST[a] = true;
		}
	}
}

double TSP::twooptsolve(size_t initial_vertex) {
	
	if (!isHoldingTriangleInequality()) {
		printf("Cannot calculate 2-OPT Path\n");
		return 0;
	}

	primMST();

	std::vector <size_t> euler_cycle = get_euler_cycle(mst, initial_vertex);

	best_path = euler_cycle;
	best_path.push_back(initial_vertex);

	return 1;
}

void TSP::get_euler_cycle_rec(const std::vector<std::vector<size_t>> &tree, size_t v, std::vector<size_t> &answer) {
	answer.push_back(v);
	visited[v] = true;
	for (size_t u : tree[v]) {
		if(!visited[u]) get_euler_cycle_rec(tree, u, answer);
	}
}

std::vector<size_t> TSP::get_euler_cycle(const std::vector<std::vector<size_t>> &tree, size_t v) {
	std::vector<size_t> answer;
	get_euler_cycle_rec(tree, v, answer);
	return answer;
}


