#include "stdafx.h"
#include "dbscan.h"


int DBScan::run()
{
	int clusterID = 0;
	for (UINT i = 0; i < points.size(); i++)
	{
		printf("\rClustering points %d/%d", i + 1, points.size());
		if (points_clusterId[i] == UNCLASSIFIED)
		{
			if (expandCluster(i, clusterID) != FAILURE)
			{
				clusterID++;
			}
		}
	}
	printf("\n");

	return 0;
}

int DBScan::expandCluster(int idx, int clusterID)
{
	vector<int> clusterSeeds = calculateCluster(points[idx]);
	int size = clusterSeeds.size();
	vector<int> ids;

	if (size < m_minPoints && size >= max_cluster_size)
	{
		points_clusterId[idx] = NOISE;
		return FAILURE;
	}

	else
	{
		int index = 0, indexCorePoint = 0;
		for (int i = 0; i < clusterSeeds.size(); i++)
		{
			points_clusterId[clusterSeeds[i]] = clusterID;
			ids.push_back(clusterSeeds[i]);
			if (points[clusterSeeds[i]].x == points[idx].x && points[clusterSeeds[i]].y == points[idx].y && points[clusterSeeds[i]].z == points[idx].z)
			{
				indexCorePoint = index;
			}
			index++;
		}

		clusterSeeds.erase(clusterSeeds.begin() + indexCorePoint);
		
		for (int i = 0, n = clusterSeeds.size(); i < n; i++)
		{
			if (size >= max_cluster_size) break;

			vector<int> clusterNeighors = calculateCluster(points[clusterSeeds[i]]);

			if (clusterNeighors.size() >= m_minPoints)
			{
				for (int i = 0; i < clusterNeighors.size(); i++)
				{
					if (points_clusterId[clusterNeighors[i]] == UNCLASSIFIED || points_clusterId[clusterNeighors[i]] == NOISE)
					{
						if (points_clusterId[clusterNeighors[i]] == UNCLASSIFIED)
						{
							clusterSeeds.push_back(clusterNeighors[i]);
							n = clusterSeeds.size();
						}
						points_clusterId[clusterNeighors[i]] = clusterID;
						ids.push_back(clusterNeighors[i]);
						size++;
					}
					if (size >= max_cluster_size) break;
				}
			}
		}
		if (ids.size() <= min_cluster_size)
		{
			for (int i = 0; i < ids.size(); i++)
			{
				points_clusterId[ids[i]] = NOISE;
			}
		}

		return SUCCESS;
	}
}

vector<int> DBScan::calculateCluster(CapturingReality::CoordinateSystemPoint &point)
{
	int index = 0;
	vector<int> clusterIndex;

	for (int i = 0 ; i < points.size(); i++)
	{
		if (calculateDistance(point, points[i]) <= m_epsilon)
		{
			clusterIndex.push_back(index);
		}
		index++;
	}
	return clusterIndex;
}


inline double DBScan::calculateDistance(CapturingReality::CoordinateSystemPoint &p1, CapturingReality::CoordinateSystemPoint &p2)
{
	return pow(p1.x - p2.x, 2) + pow(p1.y - p2.y, 2) + pow(p1.z - p2.z, 2);
}
