#pragma once

#define _gamma 5.828427124 // FOUR_GAMMA_SQUARED = sqrt(8)+3;
#define _cstar 0.923879532 // cos(pi/8)
#define _sstar 0.3826834323 // sin(p/8)
#define EPSILON 1e-6

class svd3d
{
public:
	svd3d() {}

	void run(
		__in_ecount(9) const double *a,
		__out_ecount(9) double *u,
		__out_ecount(9) double *s,
		__out_ecount(9) double *v);

private:
	void QRGivensQuaternion(double a1, double a2, double &ch, double &sh);
	inline void approximateGivensQuaternion(__in_ecount(9) const double *a, double &ch, double &sh);
	inline void jacobiConjugation(const int x, const int y, const int z,
		__inout_ecount(9) double *s,
		__out_ecount(4) double *qV);
	inline void jacobiEigenanlysis(
		__inout_ecount(9) double *s,
		__out_ecount(4) double *qV);

	inline void sortSingularValues(// matrix that we want to decompose
		__inout_ecount(9) double *b,
		__inout_ecount(9) double *v);

	inline void QRDecomposition(// matrix that we want to decompose
		__inout_ecount(9) double *b,
		__inout_ecount(9) double *q,
		__inout_ecount(9) double *r);

	inline float dist2(double x, double y, double z)
	{
		return x * x + y * y + z * z;
	}

};

