#include "stdafx.h"
#include "Tracks.h"


HRESULT TracksPage::CreateInstance( __deref_out TracksPage **ppTracksPage )
{
    if ( !ppTracksPage )
    {
        return E_POINTER;
    }

    TracksPage *pObject = new TracksPage();
    if ( !pObject )
    {
        return E_OUTOFMEMORY;
    }

    HRESULT hr = pObject->Initialize();
    if ( SUCCEEDED(hr) )
    {
        pObject->AddRef();
        *ppTracksPage = pObject;
    }
    else
    {
        delete pObject;
    }

    return hr;
}

TracksPage::TracksPage()
{
    m_RefCount = 0;
}

TracksPage::~TracksPage()
{
    _ASSERT( m_RefCount == 0 );
}

HRESULT TracksPage::Initialize( )
{
	// a place for some work
	return S_OK;
}

STDMETHODIMP TracksPage::QueryInterface(REFIID riid, __deref_out_opt void **ppvObject)
{
    if ( riid == __uuidof(IControlPoints) )
    {
        *ppvObject = (void*)(IControlPoints*)this;
    }
    return E_NOTIMPL;
}

STDMETHODIMP_(ULONG) TracksPage::AddRef()
{
    return InterlockedIncrement(&m_RefCount);
}

STDMETHODIMP_(ULONG) TracksPage::Release()
{
    ULONG refCnt = InterlockedDecrement(&m_RefCount);
    if ( !refCnt )
    {
        delete this;
    }
    return refCnt;
}
