#pragma once

using namespace CapturingReality::CoordinateSystems;
using namespace CapturingReality::Sfm;
using namespace CapturingReality;

#define TRACKS_PAGE_SIZE 1024

class TracksPage
{
private:

	std::array< SfmReconstructionControlPoint, TRACKS_PAGE_SIZE> m_tracks;

	// for CComObject interface 
	volatile LONG m_RefCount;

public:
	
	static HRESULT CreateInstance( __deref_out TracksPage **ppTracksPage );

    TracksPage();

    ~TracksPage();

	HRESULT Initialize();

	SfmReconstructionControlPoint *GetAt( __in UINT index )
	{
		return &m_tracks[index];
	};

    // CComObject interface methods.

    STDMETHOD(QueryInterface)(REFIID riid, __deref_out_opt void **ppvObject);

    STDMETHOD_(ULONG, AddRef)();

    STDMETHOD_(ULONG, Release)();
};


class Tracks
{
private:

	std::vector< CComPtr< TracksPage > > m_pagedVector;

	UINT m_count;

public:

	Tracks()
	{
		m_count = 0;
	};

	HRESULT AddNew( __out SfmReconstructionControlPoint **ppTrack )
	{
		HRESULT hr = S_OK;
		UINT pagesCount = (UINT)m_pagedVector.size();
		if ( m_count+1 > pagesCount * TRACKS_PAGE_SIZE )
		{
			CComPtr< TracksPage > spNewPage;
			hr = TracksPage::CreateInstance( &spNewPage );
			if ( SUCCEEDED( hr ) )
			{
				m_pagedVector.push_back( spNewPage );
			}
		}

		m_count++;
		
		*ppTrack = GetAt( m_count - 1 );

		return hr;
	};

	SfmReconstructionControlPoint *GetAt( __in UINT trackIndex )
	{
		if ( trackIndex > m_count-1 )
		{
			return NULL;
		}
		else
		{
			return m_pagedVector[ trackIndex / TRACKS_PAGE_SIZE ]->GetAt( trackIndex % TRACKS_PAGE_SIZE );
		}
	};

	UINT GetCount()
	{
		return m_count;
	};
};
