#pragma once

//using namespace CapturingReality::RealityCaptureServices;
#include <vector>

HRESULT SimulateFlight(
	__in const std::vector<CapturingReality::CoordinateSystemPoint> &camera_positions,
	__in const std::vector<CapturingReality::CoordinateSystemPoint> &lookat_positions,
	__in const int &sim_iteration,
	__in const std::string &model_path);

HRESULT SimulateFlightWithPath(
	__in const std::vector<CapturingReality::CoordinateSystemPoint> &camera_positions,
	__in const std::vector<CapturingReality::CoordinateSystemPoint> &lookat_positions,
	__in const std::vector<std::vector<CapturingReality::CoordinateSystemPoint>> &paths,
	__in const int &sim_iteration,
	__in const std::string &model_path);

HRESULT RenderPoints(__in std::vector<float> vertices);

std::vector<float> MakeSimpleVertices(__in std::vector<CapturingReality::CoordinateSystemPoint> &points, float R, float G, float B);

std::vector<float> MakeGroupedVertices(__in std::vector<CapturingReality::CoordinateSystemPoint> &points, __in std::vector<int> &clusters_id);

void ConcatVectors(
	__deref_inout std::vector<float> &vector1,
	__in std::vector<float> &vector2);

void scaleVertices(__deref_inout std::vector<float> &points, float scale);