#include "ctc_predictions.h"
#include <string>
#include <stdexcept>
using std::vector;

CtcPredictions::CtcPredictions(vector<double> label_priors, vector<vector<double>> predictions) {
  if (label_priors.size() != kLabelTypes) {
    std::string message = "label_priors must have " + std::to_string(kLabelTypes) + " elements";
    throw std::invalid_argument(message);
  }
  predictions_.resize(predictions.size(), vector<Probability> (kLabelTypes));
  conditionals_.resize(predictions.size(), vector<Probability> (kLabelTypes));
  for (unsigned position = 0; position < predictions.size(); position++) {
    if (predictions[position].size() != kLabelTypes) {
      std::string message = "predictions must have " + std::to_string(kLabelTypes) + " elements per position";
      throw std::invalid_argument(message);
    }
    for (unsigned label = 0; label < kLabelTypes; label++) {
      predictions_[position][label] = Probability::FromP(predictions[position][label]);
      conditionals_[position][label] = predictions_[position][label] / Probability::FromP(label_priors[label]);
    }
  }
}
