#ifndef HMM_DECODER_H
#define HMM_DECODER_H
#include <vector>
#include "probability.h"
#include "ctc_predictions.h"
#include "model.h"

class Decoder {
protected:
  virtual std::vector<Probability> DecodeInternal(const CtcPredictions &ctc_predictions, const Model &model) = 0;
public:
  std::vector<double> Decode(const std::vector<std::vector<double>> &ctc_predictions, 
                             const std::vector<double> &label_priors, 
                             const Model &model);
};

/*
class PosteriorPathDecoder : public CoherentPathDecoder {
  
};
*/

#endif
