#ifndef HMM_FULL_MODEL_H
#define HMMFFULL_MODEL_H
#include "model.h"

class FullModel : public Model {
  struct Level {
    int period_;
    unsigned main_entry_state_;
    unsigned detailed_entry_states_[kNucleotideTypes][kLabelTypes]; // left, !right
    unsigned generative_states_[kNucleotideTypes][kLabelTypes];
    unsigned catchup_states_[kLabelTypes][kLabelTypes];
    
    std::vector<unsigned> advancing_arcs_;
    std::vector<int> advancement_periods_;
  };
  
  std::vector<Level> levels_;
  Level fake_level_;
  std::vector<std::vector<Probability>> match_matrix_;
  std::vector<Probability> nucleotides_distribution_;
  Probability p_nucleotide_is_indel_;
  Probability p_linger_nucleotide_;
  Probability p_linger_blank_;
  Probability p_nucleotide_;
  Probability p_blank_;
  
  unsigned background_generating_states_[kLabelTypes];
  unsigned background_entry_state_;
  
  void InitializeFakeLevel();
  void BuildMainEntryArcs(Level &level);
  void BuildDetailedEntryArcs(Level &level, 
                              unsigned left_label, 
                              unsigned forbidden_right);
  void BuildNucleotideGenerativeArcs(Level &level, 
                                     const Level &next_level,
                                     unsigned left_label,
                                     unsigned right_label);
  void BuildBlankGenerativeArcs(Level &level, 
                                const Level &next_level,
                                unsigned left_label);
  void BuildNucleotideCatchupArcs(Level &level, 
                                  const Level &previous_level, 
                                  unsigned left_label, 
                                  unsigned forbidden_right);
  void BuildBlankCatchupArcs(Level &level, 
                             const Level &previous_level, 
                             unsigned forbidden_right);
  
  
protected:
  unsigned BuildLevelStates(int period) override;
  void BuildLevelArcs(int period) override;
  void RegisterLevel(int period) override;
  
  void BuildBackgroundStates() override;
  void BuildBackgroundArcs() override;
  void RegisterBackground() override;
public:
  FullModel(int min_period, 
            int max_period, 
            double period_probability_decay, 
            double p_nucleotide_stay_background,
            double p_nucleotide_stay_repeat,
            double p_nucleotide_is_indel,
            double p_linger_nucleotide,
            double p_linger_blank,
            std::vector<double> nucleotides_distribution,
            std::vector<std::vector<double>> match_matrix);
};

#endif
