#include "model.h"

class LingerModel : public Model {
  struct Level {
    unsigned entry_state_;
    unsigned nucleotide_states_[kNucleotideTypes];
    unsigned nucleotide_catchup_states_[kNucleotideTypes];
    unsigned blank_state_;
    unsigned blank_catchup_state_;
  };
  
  std::vector<Level> levels_;
  std::vector<Probability> nucleotides_distribution_;
  Probability p_linger_nucleotide_;
  Probability p_linger_blank_;
  
protected:
  unsigned BuildLevelStates(int period) override;
  void BuildLevelArcs(int period) override;
  void RegisterLevel(int period) override;
  
  void BuildBackgroundStates() override;
  void BuildBackgroundArcs() override;
  void RegisterBackground() override;
public:
  LingerModel(int min_period,
              int max_period, 
              double period_probability_decay, 
              double p_nucleotide_stay_background, 
              double p_nucleotide_stay_repeat, 
              double p_linger_nucleotide, 
              double p_linger_blank, 
              std::vector<double> nucleotides_distribution);
};
