#ifndef HMM_SIMPLE_MODEL_H
#define HMM_SIMPLE_MODEL_H
#include <vector>
#include "model.h"

class SimpleModel : public Model {
  std::vector<std::vector<Probability>> match_emission_matrix_;
  std::vector<Probability> blank_emissions_;
  std::vector<Probability> label_prior_distribution_;
  Probability p_gap_or_insertion_;
  Probability p_nucleotide_is_indel_;
  Probability p_nucleotide_;
  Probability p_blank_;
  
  struct Level {
    unsigned match_state_;
    unsigned gap_star_state_;
    unsigned gap_state_;
    unsigned catchup_state_;
    std::vector<unsigned> match_arcs_;
    std::vector<unsigned> gap_star_arcs_;
    std::vector<unsigned> gap_arcs_;
    std::vector<unsigned> catchup_arcs_;
  };
  
  std::vector<Level> levels_;
  unsigned background_entry_state_;
  unsigned background_nucleotide_state_;
  unsigned background_blank_state_;
  
  void ComputeBlankEmissions();
  
protected:
  unsigned BuildLevelStates(int period) override;
  void BuildLevelArcs(int period) override;
  void RegisterLevel(int period) override;
  
  void BuildBackgroundStates() override;
  void BuildBackgroundArcs() override;
  void RegisterBackground() override;
  
public:
  SimpleModel(int min_period, 
              int max_period,
              double period_probability_decay,
              std::vector<double> label_prior_probabilities,
              double p_nucleotide_stay_background,
              double p_nucleotide_stay_repeat,
              double p_nucleotide_is_indel,
              std::vector<std::vector<double>> match_matrix);
};

#endif
