#include <movement_model.h>
#include <queue>
#include <cstdio>
using namespace std;

MovementModel::MovementModel(int max_speed_ratio, int signal_length)
  : max_speed_ratio_(max_speed_ratio),
    signal_length_(signal_length) { }

int MovementModel::MaxMovementRows(int row) const {
  return min(max_speed_ratio_, signal_length_ - row);
}

int MovementModel::MaxMovementCols(int col) const {
  return min(max_speed_ratio_, signal_length_ - col);
}
