#include <pybind11/pybind11.h>
#include <pybind11/stl.h>
#include <alignment.h>


namespace py = pybind11;

PYBIND11_MODULE(signal_dtw, m) {
  m.doc() = "A C++ implementation of signal dtw";
  
  py::class_<Scorer>(m, "Scorer");
  
  py::class_<SimpleScorer, Scorer>(m, "SimpleScorer")
    .def(py::init<std::vector<double>,
                  std::vector<double>,
                  double>())
    .def("Score", &SimpleScorer::Score, "",
         py::arg("row"), 
         py::arg("col"), 
         py::arg("row_new") = true,
         py::arg("col_new") = true);
    
    
  py::class_<MovementModel>(m, "MovementModel")
    .def(py::init<int, int>());
  
  m.def("local_alignment", &local_alignment, "",
        py::arg("rows"), py::arg("cols"), py::arg("scorer"),
        py::arg("movement_model"), py::arg("row_starts"), 
        py::arg("row_ends"), py::arg("min_lookahead"), 
        py::arg("log_filename")="");

#ifdef VERSION_INFO
  m.attr("__version__") = VERSION_INFO;
#else
  m.attr("__version__") = "dev";
#endif
}
