import sys
import os
from nadavca.read import Read
from scipy.special import softmax
import numpy as np
import signal_dtw
import time
from predict_by_basecall import predict_by_basecall

if len(sys.argv) != 7:
    print("usage: {} reads_dir alignments_dir output_dir gap_cost mismatch_cost max_period".format(sys.argv[0]))
    sys.exit(0)


reads_dir = sys.argv[1]
alignments_dir = sys.argv[2]
output_dir = sys.argv[3]
gap_cost = int(sys.argv[4])
mismatch_cost = int(sys.argv[5])
max_period = int(sys.argv[6])

os.mkdir(output_dir)
total_time = 0
total_signals = 0

for read_filename in os.listdir(reads_dir):
    print("processing {}".format(read_filename))
    basename = os.path.splitext(read_filename)[0]
    other_filename = basename + '.txt'
    alignment_path = os.path.join(alignments_dir, other_filename)
    read_path = os.path.join(reads_dir, read_filename)
    
    start = time.time()
    result = predict_by_basecall(read_path, alignment_path, gap_cost, mismatch_cost, max_period)
    end = time.time()
    total_time += end - start
    total_signals += len(result)
    sys.stderr.write("processed in {} (overall average {} signals per second)\n".format(end - start, total_signals / total_time))
    
    out_path = os.path.join(output_dir, other_filename)
    with open(out_path, 'w') as outfile:
        outfile.write('\n'.join(map(str, result)))
