#include "coherent_path_decoder.h"
using std::vector;
using std::min;
using std::max;

vector<Probability> CoherentPathDecoder::StateSequenceToRepeats(vector<unsigned> states_sequence,
                                                                vector<unsigned> arcs_sequence,
                                                                int emitted_labels_count, 
                                                                const Model &model) {
  vector<Probability> result(emitted_labels_count, Probability::FromP(0));
  
  int right_position = 0;
  bool in_repeat = false;
  int left_start, right_start;
  int left_end, right_end;
  
  for (unsigned i = 0; i < states_sequence.size(); i++) {
    unsigned state = states_sequence[i];
    if (model.IsRepeat(state)) {
      if (!in_repeat) {
        in_repeat = true;
        left_start = std::numeric_limits<int>::max();
        right_start = std::numeric_limits<int>::max();
        left_end = std::numeric_limits<int>::lowest();
        right_end = std::numeric_limits<int>::lowest();
      }
      right_start = min(right_start, right_position);
      right_end = max(right_end, right_position+1);
      
      if (!model.IsEpsilon(state)) {
        right_position++;
      }
      
      if (i < arcs_sequence.size()) {
        unsigned arc = arcs_sequence[i];
        if (model.IsArcAdvancingLeft(arc)) {
          int left_position = right_position - model.AdvancingArcPeriod(arc);
          left_start = min(left_start, left_position);
          left_end = max(left_end, left_position+1);
        }
      }
      
    }
    else {
      if (in_repeat) {
        in_repeat = false;
        if (left_end >= right_start) {
          for (int position = left_start; position < right_end; position++) {
            result[position] = Probability::FromP(1);
          }
        }
      }
      if (!model.IsEpsilon(state)) {
        right_position++;
      }
    }
    
  }
  if (in_repeat) {
    if (left_end >= right_start) {
      for (int position = left_start; position < right_end; position++) {
        result[position] = Probability::FromP(1);
      }
    }
  }
  return result;
}
