#include "decoder.h"
using std::vector;

vector<double> Decoder::Decode(const vector<vector<double>> &ctc_predictions, 
                               const vector<double> &label_priors,
                               const Model &model) {
  vector<Probability> decoded = DecodeInternal(CtcPredictions(label_priors, ctc_predictions), model);
  vector<double> result(decoded.size());
  for (unsigned i = 0; i < decoded.size(); i++) {
    result[i] = decoded[i].Get();
  }
  return result;
}
