#ifndef HMM_MODEL_H
#define HMM_MODEL_H
#include "hmm.h"
#include "probability.h"
#include <vector>

class Model {
protected:
  Hmm *hmm_;
  int min_period_;
  int max_period_;
  Probability period_probability_decay_;
  Probability p_nucleotide_stay_background_;
  Probability p_nucleotide_stay_repeat_;
  
  unsigned repeat_entry_state_;
  unsigned post_repeat_state_;
  
  std::vector<bool> is_state_background_;
  std::vector<bool> is_state_repeat_;
  std::vector<bool> is_state_epsilon_;
  std::vector<bool> is_arc_advancing_left_;
  std::vector<int> advancing_arc_period_;
  
  
  virtual unsigned BuildLevelStates(int period) = 0;
  virtual void BuildLevelArcs(int period) = 0;
  virtual void RegisterLevel(int period) = 0;
  
  virtual void BuildBackgroundStates() = 0;
  virtual void BuildBackgroundArcs() = 0;
  virtual void RegisterBackground() = 0;
  
  void BuildHmm();
  
public:
  Model(int min_period,
        int max_period,
        double period_probability_decay,
        double p_nucleotide_stay_background,
        double p_nucleotide_stay_repeat);
  
  bool IsBackground(unsigned state) const;
  bool IsRepeat(unsigned state) const;
  bool IsEpsilon(unsigned state) const;
  bool IsArcAdvancingLeft(unsigned arc) const;
  int AdvancingArcPeriod(unsigned arc) const;
  
  const Hmm* GetHmm() const;
  virtual ~Model();
};


#endif
