#ifndef NADAVCA_PROBABILITY_H
#define NADAVCA_PROBABILITY_H

class Probability {
private:
  double log_val_;
  Probability(double logp);
public:
  Probability();
  
  static Probability FromP(double p);

  double Get() const;
  bool IsNan() const;
  double GetLog() const;
  
  Probability &operator*=(const Probability &other);
  Probability &operator+=(const Probability &other);
  Probability &operator/=(const Probability &other);
  Probability &operator|=(const Probability &other);
  Probability operator*(Probability other) const;
  Probability operator+(Probability other) const;
  Probability operator/(Probability other) const;
  Probability operator||(Probability other) const;
  bool operator<(Probability other) const;
  bool operator>(Probability other) const;
  bool operator<=(Probability other) const;
  bool operator>=(Probability other) const;
  
  Probability Negate() const;
};
#endif
