#ifndef HMM_VITERBI_DECODER_H
#define HMM_VITERBI_DECODER_H
#include "coherent_path_decoder.h"

class ViterbiDecoder : public CoherentPathDecoder {
  unsigned kInvalidId = std::numeric_limits<unsigned>::max();
  
  struct PathFindingEntry {
    int ref_count_;
    unsigned state_id_;
    unsigned arc_id_;
    unsigned next_;
  };
  
  std::vector<PathFindingEntry> path_finding_entries_;
  std::vector<unsigned> free_indices_;
  unsigned AddEntry(unsigned state_id);
  void Link(unsigned entry_from, unsigned entry_to, unsigned arc_id);
  void DropReference(unsigned entry_id);
  void Remove(unsigned entry_id);
  
  
protected:
  std::vector<Probability> DecodeInternal(const CtcPredictions &ctc_predictions, const Model &model) override;
public:
  ViterbiDecoder();
};

#endif
