import numpy as np

def peak_filter(probs):
    result = np.zeros(probs.shape, dtype=float)
    for i in range(4):
        result[0][i] = probs[0][i]
        result[-1][i] = probs[-1][i]
        for j in range(1, len(probs)-1):
            if probs[j][i] < probs[j-1][i] or probs[j][i] <= probs[j+1][i]:
                result[j][i] = probs[j][i] / 100
            else:
                result[j][i] = probs[j][i]
    for row in result:
        row[4] = 1 - np.sum(row[:4])
    return result
