#include <scorer.h>
#include <cmath>
#include <cstdio>
using namespace std;


SimpleScorer::SimpleScorer(const vector<double>& signal_y,
                           const vector<double>& signal_x,
                           double bonus)
  : signal_y_(signal_y), 
    signal_x_(signal_x),
    bonus_(bonus/2) {}

double SimpleScorer::Score(int row, int col, bool row_new, bool col_new) const {
  double delta = signal_y_[row] - signal_x_[col];
  return bonus_*row_new + bonus_*col_new - delta * delta;
}
