#ifndef SCORER_H
#define SCORER_H
#include <vector>

class Scorer {
public:
  virtual double Score(int row, int col, bool row_new=true, bool col_new=true) const = 0;
};

class SimpleScorer : public Scorer {
  std::vector<double> signal_y_, signal_x_;
  double bonus_;
public:
  SimpleScorer(const std::vector<double>& signal_y,
               const std::vector<double>& signal_x,
               double bonus);
  double Score(int row, int col, bool row_new=true, bool col_new=true) const override;
};

#endif
