#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../common.h"

/*
BUG: Niektori blazni si zadavaju 100-znakove hesla?!
     Radsej to spravme dynamicky.

char heslo[20];

void set_heslo(const char *noveheslo)
{
	strcpy(heslo, noveheslo);
}

*/

char *heslo = NULL;

void set_heslo(const char *noveheslo)
{
	if (heslo != NULL)
		free(heslo);

	size_t dlzka = strlen(noveheslo);
	if (dlzka < 20)  // Prilis kratke heslo!
		_exit(1);

	heslo = malloc(dlzka + 1);
	if (heslo == NULL)
		_exit(1);

	memcpy(heslo, noveheslo, dlzka + 1);
}


void test(const char *vstup)
{
	if (strlen(vstup) != strlen(heslo))
	{
		printf("Zla dlzka hesla!\n");
		return;
	}

	if (memcmp(vstup, heslo, sizeof(heslo)) != 0)
	{
		printf("Zle heslo!\n");
		return;
	}
	printf("Vitajte v nasom supertajnom systeme!\n");
}

int main()
{
	setup();

	char tmp[101];
	while(scanf("%100s", tmp) == 1)
		test(tmp);
	return 0;
}
