package water;

public class Pipe extends Canvas implements WaterListener, Runnable {

	private Vector waterListeners = new Vector();
	private WaterEventObject lastWaterEvent;
	protected Thread thread;

	public Pipe() {
		setBackground(Color.white);
		thread = new Thread(this);
		thread.start();
	}
	
	
	public Dimension getMinimumSize() {
		return new Dimension(150,10);
	}

	public void handleSplash(WaterEventObject e) {
		lastWaterEvent = e;
		setBackground(Color.blue);
		repaint();
		splash();
	}

	public void run() {
		while(true) {
			try {
				thread.sleep(1000);
			} catch (Exception e) {}
			if (lastWaterEvent != null) {
				long dt = System.currentTimeMillis() -lastWaterEvent.
				getTimeOfEvent();
				if (dt > 2000) {
					setBackground(Color.white);
					repaint();
				}
			}
		}
	}

	public synchronized void addWaterListener(WaterListener l) {
		waterListeners.addElement(l);
	}

	public synchronized void removeWaterListener(WaterListener l) {
		waterListeners.removeElement(l);
	}

	protected void splash() {
		WaterEventObject weo = new WaterEventObject(this);
		for (int i = 0; i < waterListeners.size(); i++) {
			WaterListener wl = (WaterListener)waterListeners.elementAt(i);
			wl.handleSplash(weo);
		}
	}
}

