// --------------------------------------------------------------------------------
// DrawStringApplet

// import all classes from package awt
import java.awt.*;
// import class Applet from package applet
import java.applet.Applet;

// class Hello
public class DrawStringApplet extends Applet {

    // ------------------------------------------------
	// --- public members

	// metoda init - vola sa pri "zavedeni" appletu do pamate
	public void init() {
		initUI();
		showStatus("Initialized...");
	}
	
	// metoda start - vola sa vzdy ked je applet aktivovany
	public void start() {
		showStatus("Start !");
	}
	
	// metoda stop - vola sa ked ma applet zastavit svoje "aktivity"
	public void stop() {
		showStatus("Applet is stopped");
	}
	
	// metoda action - vola pre spracovanie "akcie"
	public boolean action(Event evt, Object arg) {
		if (evt.target instanceof Button) {
			if ("Draw !".equals(arg)) {
				if (textToDraw != null) {
					if (drawingPanel != null) {
						drawingPanel.setText(textToDraw.getText());
						drawingPanel.repaint();
						return true;
					} else {
						System.err.println("What ?! Where is my drawing panel ?!");
					}
				} else {
					System.err.println("What ?! Where is my textfield ?!");
				}
			}
		}
		return false;
	}

    // ------------------------------------------------
	// --- protected members

	// metoda initUI - inicializacia userinterface
	protected void initUI() {
		setLayout(new BorderLayout());
		add("North", inputPanel = new Panel());
		add("Center", drawingPanel = new DrawPanel());
		inputPanel.setLayout(new BorderLayout());
		inputPanel.add("Center", textToDraw = new TextField());
		inputPanel.add("East", drawIt = new Button("Draw !"));
	}

    // ------------------------------------------------
	// --- private members

	// button
	private Button drawIt = null;

	// textfield odkial bude nacitany string
	private TextField textToDraw = null;

	// panel kam bude text zobrazovany
	private DrawPanel drawingPanel = null;

	// panel pre "input" polozky UI
	private Panel inputPanel = null;

}
