// ------------------------------------------------------------------
// EnclosingClass - example of inner classes using

// imports
import java.io.*;

public class EnclosingClass  {

	public class InnerClass {
	
		public InnerClass(String s) {
			str = s;
		}
		
		public void print() {
			System.out.println("InnerClass object          : " + str);
			System.out.println("InnerClass enclosing object: " + txt);
		}
	
		protected String str;

	}


	public EnclosingClass(String s1, String s2) {
		txt = s1;
		innerObj = new InnerClass(s2);		
	}
		
	public void print() {
		System.out.println("EnclosingClass object      : " + txt);
		innerObj.print();
		
	}
	
	protected String txt;
	protected InnerClass innerObj;


	public static void main(String args[]) {

		String s1, s2;

		if (args.length > 0) {
			s1 = args[0];
			if (args.length > 1) {
				s2 = args[1];
			} else {
				s2 = "s2";
			}
		} else {
			s1 = "s1";
			s2 = "s2";
		}
		
		EnclosingClass t = new EnclosingClass(s1, s2);
		t.print();
		
	}

}

